﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint.Client;

namespace TrimmingQuery
{
   class Program
   {
      static void Main(string[] args)
      {          
         ClientContext ctx = new ClientContext("http://contoso.de");
         
         Web web = ctx.Web;
         List customer = web.Lists.GetByTitle("Kunden");

         // Collection aller Listenelemente 
         ListItemCollection items = customer.GetItems(
            new CamlQuery() { ViewXml = "<View/>" });

         // Daten laden und Eigenschaften einschränken
         ctx.Load(customer,
            c => c.Title,            
            c => c.ItemCount);

         // Eigenschaften des Listenelements einschränken
         ctx.Load(items,
            item => item.Include(
               i => i["Title"],
               i => i["FirstName"],
               i => i["Company"]
               ));
         
         ctx.ExecuteQuery();

         Console.WriteLine("Liste:{0} (Anzahl Elemente: {1})\n",
            customer.Title, customer.ItemCount);

         // Listenelemente iterieren 
         foreach (ListItem i in items)
         {
            Console.WriteLine("Unternehmen: {0}",
              i["Company"]);
            Console.WriteLine("Nachname: {0}",
               i["Title"]);
            Console.WriteLine("Vorname: {0}\n",
               i["FirstName"]);           
         }
      }
   }
}
